/*
 * Decompiled with CFR 0.152.
 */
import java.util.Stack;
import java.util.Vector;

class RoleRes {
    static final byte WAIT_ACTION = 1;
    static final byte RUN_ACTION = 2;
    static final byte CLOSE_ACTION = 3;
    static final byte PUSH_ACTION = 4;
    static final byte KNOCK_ACTION = 5;
    static final byte CLOSE_LEFT_ACTION = 6;
    static final byte CLOSE_RIGHT_ACTION = 7;
    static final byte TO_BOMB_ACTION = 8;
    static final byte BOMB_ACTION = 9;
    static final byte BOMB_TO_STAND_ACTION = 10;
    static final byte LOST_ACTION = 11;
    static final byte DIE_ACTION = 12;
    static final byte TO_BOMB_ACTION_BACK = 13;
    static final byte BOMB_ACTION_BACK = 14;
    static final byte BOMB_TO_STAND_ACTION_BACK = 15;
    static final byte KNOCK_TO_CLOSE_ACTION = 16;
    static final byte TO_KILL_ACTION = 17;
    static final byte KILL_ACTION = 18;
    static final byte TO_BE_KILLED_ACTION = 19;
    static final byte BE_KILLED_ACTION = 20;
    public static final byte NONE = 0;
    public static final byte UP = 1;
    public static final byte DOWN = 8;
    public static final byte LEFT = 2;
    public static final byte RIGHT = 7;
    public static final byte UP_LEFT = 3;
    public static final byte UP_RIGHT = 6;
    public static final byte DOWN_LEFT = 4;
    public static final byte DOWN_RIGHT = 5;
    public static final byte PLAYER = 0;
    public static final byte ENEMY = 1;
    public static final byte NPC = 2;
    public static final byte STATE_NONE = 0;
    public static final byte STATE_PATROL = 1;
    public static final byte STATE_HEAR_SOUND = 2;
    public static final byte STATE_TO_SOUND = 3;
    public static final byte STATE_SOUND_MAZE = 4;
    public static final byte STATE_TO_PATROL = 5;
    public static final byte STATE_TO_ROLE = 6;
    public byte state = 0;
    public Integer id;
    public String name;
    public String modelFile = null;
    public String textureFile = null;
    public String actionFile = null;
    public boolean autoAction = true;
    public boolean backPlay = false;
    public String actionWaitFile = null;
    public int actionWaitFrameNum = 0;
    public int actionWaitFrameMax = 0;
    public String actionRunFile = null;
    public int actionRunFrameNum = 0;
    public int actionRunFrameMax = 0;
    public String actionPushFile = null;
    public int actionPushFrameNum = 0;
    public int actionPushFrameMax = 0;
    public String actionCloseFile = null;
    public int actionCloseFrameNum = 0;
    public int actionCloseFrameMax = 0;
    public String actionCloseLeftFile = null;
    public int actionCloseLeftFrameNum = 0;
    public int actionCloseLeftFrameMax = 0;
    public String actionCloseRightFile = null;
    public int actionCloseRightFrameNum = 0;
    public int actionCloseRightFrameMax = 0;
    public String actionToBombFile = null;
    public int actionToBombFrameNum = 0;
    public int actionToBombFrameMax = 0;
    public String actionBombFile = null;
    public int actionBombFrameNum = 0;
    public int actionBombFrameMax = 0;
    public String actionBombToStandFile = null;
    public int actionBombToStandFrameNum = 0;
    public int actionBombToStandFrameMax = 0;
    public String actionLostFile = null;
    public int actionLostFrameNum = 0;
    public int actionLostFrameMax = 0;
    public String actionDieFile = null;
    public int actionDieFrameNum = 0;
    public int actionDieFrameMax = 0;
    public String actionKnockFile = null;
    public int actionKnockFrameNum = 0;
    public int actionKnockFrameMax = 0;
    public String actionKnockToCloseFile = null;
    public int actionKnockToCloseFrameNum = 0;
    public int actionKnockToCloseFrameMax = 0;
    public String actionToKillFile = null;
    public int actionToKillFrameNum = 0;
    public int actionToKillFrameMax = 0;
    public String actionKillFile = null;
    public int actionKillFrameNum = 0;
    public int actionKillFrameMax = 0;
    public String actionToBeKilledFile = null;
    public int actionToBeKilledFrameNum = 0;
    public int actionToBeKilledFrameMax = 0;
    public String actionBeKilledFile = null;
    public int actionBeKilledFrameNum = 0;
    public int actionBeKilledFrameMax = 0;
    public Vector trackList = new Vector();
    public Vector itemList = new Vector();
    public boolean isKill = false;
    public int killTick = 0;
    public boolean isMaze = false;
    public int mazeTick = 0;
    public int shockTick = 0;
    public boolean isShock = false;
    public boolean isBeFound = false;
    public boolean isFound = false;
    public int isBeFoundTick = 0;
    public boolean oldBeFound = false;
    public boolean isFoundEnemy = false;
    public boolean isRenderAfter = false;
    public boolean isAutoDirect = false;
    public int nowTrack = 0;
    public int nowTrackWait = 0;
    public byte currentAction;
    public Stack targetStack = new Stack();
    public int lostTick = -1;
    public int speed = 0;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int tx = 0;
    public int ty = 0;
    public int tz = 0;
    public int direct = 0;
    public int tdirect = 0;
    public int tspeed = 0;
    public int gx = 0;
    public int gy = 0;
    public int gz = 0;
    public int frame = 0;
    public int frameMax = 0;
    public int frameStep = 0;
    public int actionID = -1;
    public int frameNum = 0;
    public boolean halfSpeed = false;
    public boolean slowSpeed = false;

    public static int GridtoPoint(int n) {
        return (n << 7) + 64;
    }

    public void release() {
    }

    public RoleRes(int n) {
        this.id = new Integer(n);
    }

    public Vector getTrackList() {
        return this.trackList;
    }

    public void addTrack(Track track) {
        this.trackList.addElement(track);
    }

    public boolean isOnCenter() {
        return this.x >> 7 << 7 == this.x - 64 && this.y >> 7 << 7 == this.y - 64;
    }

    public boolean belongItem(int n) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            Integer n2 = (Integer)this.itemList.elementAt(i);
            int n3 = Integer.parseInt(n2.toString());
            if (n3 != n) continue;
            return true;
        }
        return false;
    }

    public boolean nextFrame() {
        if (!this.backPlay) {
            this.frame += this.frameStep;
            if (this.frame > this.frameMax) {
                this.frame = this.frameMax;
                return false;
            }
        } else {
            this.frame -= this.frameStep;
            if (this.frame < 0) {
                this.frame = 0;
                return false;
            }
        }
        return true;
    }

    public void nextFrameRoll() {
        if (!this.backPlay) {
            this.frame += this.frameStep;
            if (this.frame > this.frameMax) {
                this.frame = 0;
            }
        } else {
            this.frame -= this.frameStep;
            if (this.frame < 0) {
                this.frame = this.frameMax;
            }
        }
    }

    public byte getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(byte by) {
        this.currentAction = by;
        switch (by) {
            case 16: {
                this.actionFile = this.actionKnockToCloseFile;
                this.frameNum = this.actionKnockToCloseFrameNum;
                this.frameMax = this.actionKnockToCloseFrameMax;
                break;
            }
            case 1: {
                this.actionFile = this.actionWaitFile;
                this.frameNum = this.actionWaitFrameNum;
                this.frameMax = this.actionWaitFrameMax;
                break;
            }
            case 2: {
                this.actionFile = this.actionRunFile;
                this.frameNum = this.actionRunFrameNum;
                this.frameMax = this.actionRunFrameMax;
                break;
            }
            case 4: {
                this.actionFile = this.actionPushFile;
                this.frameNum = this.actionPushFrameNum;
                this.frameMax = this.actionPushFrameMax;
                break;
            }
            case 3: {
                this.actionFile = this.actionCloseFile;
                this.frameNum = this.actionCloseFrameNum;
                this.frameMax = this.actionCloseFrameMax;
                break;
            }
            case 5: {
                this.actionFile = this.actionKnockFile;
                this.frameNum = this.actionKnockFrameNum;
                this.frameMax = this.actionKnockFrameMax;
                break;
            }
            case 6: {
                this.actionFile = this.actionCloseLeftFile;
                this.frameNum = this.actionCloseLeftFrameNum;
                this.frameMax = this.actionCloseLeftFrameMax;
                break;
            }
            case 7: {
                this.actionFile = this.actionCloseRightFile;
                this.frameNum = this.actionCloseRightFrameNum;
                this.frameMax = this.actionCloseRightFrameMax;
                break;
            }
            case 8: 
            case 13: {
                this.actionFile = this.actionToBombFile;
                this.frameNum = this.actionToBombFrameNum;
                this.frameMax = this.actionToBombFrameMax;
                break;
            }
            case 9: 
            case 14: {
                this.actionFile = this.actionBombFile;
                this.frameNum = this.actionBombFrameNum;
                this.frameMax = this.actionBombFrameMax;
                break;
            }
            case 10: 
            case 15: {
                this.actionFile = this.actionBombToStandFile;
                this.frameNum = this.actionBombToStandFrameNum;
                this.frameMax = this.actionBombToStandFrameMax;
                break;
            }
            case 11: {
                this.actionFile = this.actionLostFile;
                this.frameNum = this.actionLostFrameNum;
                this.frameMax = this.actionLostFrameMax;
                break;
            }
            case 12: {
                this.actionFile = this.actionDieFile;
                this.frameNum = this.actionDieFrameNum;
                this.frameMax = this.actionDieFrameMax;
                break;
            }
            case 17: {
                this.actionFile = this.actionToKillFile;
                this.frameNum = this.actionToKillFrameNum;
                this.frameMax = this.actionToKillFrameMax;
                break;
            }
            case 18: {
                this.actionFile = this.actionKillFile;
                this.frameNum = this.actionKillFrameNum;
                this.frameMax = this.actionKillFrameMax;
                break;
            }
            case 19: {
                this.actionFile = this.actionToBeKilledFile;
                this.frameNum = this.actionToBeKilledFrameNum;
                this.frameMax = this.actionToBeKilledFrameMax;
                break;
            }
            case 20: {
                this.actionFile = this.actionBeKilledFile;
                this.frameNum = this.actionBeKilledFrameNum;
                this.frameMax = this.actionBeKilledFrameMax;
            }
        }
        this.frameStep = this.frameMax / this.frameNum;
    }

    public void setDirect(byte by) {
        switch (by) {
            case 1: {
                this.direct = -2048;
                break;
            }
            case 8: {
                this.direct = 0;
                break;
            }
            case 2: {
                this.direct = -1024;
                break;
            }
            case 7: {
                this.direct = 1024;
            }
        }
        this.tdirect = this.direct;
    }

    public byte get8DirectToRole(RoleRes roleRes) {
        return this.get8DirectToPoint(roleRes.x, roleRes.y);
    }

    public byte get8DirectToPoint(int n, int n2) {
        int n3 = n - this.x;
        int n4 = n2 - this.y;
        if (n3 > 0 && n4 > 0) {
            if (Math.abs(n3) >= Math.abs(n4 << 1)) {
                return 7;
            }
            if (Math.abs(n4) >= Math.abs(n3 << 1)) {
                return 1;
            }
            return 6;
        }
        if (n3 < 0 && n4 > 0) {
            if (Math.abs(n3) >= Math.abs(n4 << 1)) {
                return 2;
            }
            if (Math.abs(n4) >= Math.abs(n3 << 1)) {
                return 1;
            }
            return 3;
        }
        if (n3 > 0 && n4 < 0) {
            if (Math.abs(n3) >= Math.abs(n4 << 1)) {
                return 7;
            }
            if (Math.abs(n4) >= Math.abs(n3 << 1)) {
                return 8;
            }
            return 5;
        }
        if (n3 < 0 && n4 < 0) {
            if (Math.abs(n3) >= Math.abs(n4 << 1)) {
                return 2;
            }
            if (Math.abs(n4) >= Math.abs(n3 << 1)) {
                return 8;
            }
            return 4;
        }
        if (n3 == 0) {
            if (n4 > 0) {
                return 1;
            }
            return 8;
        }
        if (n4 == 0) {
            if (n3 > 0) {
                return 7;
            }
            return 2;
        }
        return 0;
    }

    public byte get8Direct() {
        if (this.direct >= -2048 && this.direct <= -1792 || this.direct > 1792 && this.direct <= 2048 || this.direct > -2304 && this.direct <= -2048) {
            return 1;
        }
        if (this.direct > 1280 && this.direct <= 1792 || this.direct > -2816 && this.direct <= -2304) {
            return 6;
        }
        if (this.direct > 768 && this.direct <= 1280) {
            return 7;
        }
        if (this.direct > 256 && this.direct <= 768) {
            return 5;
        }
        if (this.direct > -256 && this.direct <= 256) {
            return 8;
        }
        if (this.direct > -768 && this.direct <= -256) {
            return 4;
        }
        if (this.direct > -1280 && this.direct <= -768) {
            return 2;
        }
        if (this.direct > -1792 && this.direct <= -1280) {
            return 3;
        }
        return 0;
    }

    public byte getDirect() {
        switch (this.direct) {
            case -2048: {
                return 1;
            }
            case 0: {
                return 8;
            }
            case -1024: {
                return 2;
            }
            case 1024: {
                return 7;
            }
        }
        return 0;
    }

    public void setTarget8Direct(byte by) {
        switch (by) {
            case 1: {
                this.tdirect = -2048;
                break;
            }
            case 8: {
                this.tdirect = 0;
                break;
            }
            case 2: {
                this.tdirect = -1024;
                break;
            }
            case 7: {
                this.tdirect = 1024;
                break;
            }
            case 3: {
                this.tdirect = -1536;
                break;
            }
            case 6: {
                this.tdirect = 1536;
                break;
            }
            case 4: {
                this.tdirect = -512;
                break;
            }
            case 5: {
                this.tdirect = 512;
            }
        }
    }

    public void setTargetDirect(byte by) {
        switch (by) {
            case 1: {
                this.tdirect = -2048;
                break;
            }
            case 8: {
                this.tdirect = 0;
                break;
            }
            case 2: {
                this.tdirect = -1024;
                break;
            }
            case 7: {
                this.tdirect = 1024;
            }
        }
    }

    public void setDefaultVer() {
        this.x = 64;
        this.y = 64;
        this.z = 0;
        this.tx = this.x;
        this.ty = this.y;
        this.tz = 0;
        this.speed = 32;
        this.direct = 0;
        this.tdirect = 0;
        this.tspeed = 341;
        this.gx = (this.x - 64) / 128;
        this.gy = (this.y - 64) / 128;
        this.gz = 0;
    }

    public void setGrid(int n, int n2, int n3) {
        this.gx = n;
        this.gy = n2;
        this.gz = n3;
        this.x = (n << 7) + 64;
        this.y = (n2 << 7) + 64;
        this.z = n3 << 7;
        this.tx = this.x;
        this.ty = this.y;
        this.tz = this.z;
    }

    public void setGrid(int n, int n2) {
        this.gx = n;
        this.gy = n2;
        this.x = (n << 7) + 64;
        this.y = (n2 << 7) + 64;
        this.tx = this.x;
        this.ty = this.y;
    }

    public void turnToTarget() {
        if (this.direct - this.tdirect > 2048) {
            this.direct -= 4096;
        } else if (this.direct - this.tdirect < -2048) {
            this.direct += 4096;
        }
        if (this.tdirect - this.direct > -this.tspeed && this.tdirect - this.direct < this.tspeed) {
            this.direct = this.tdirect;
        } else if (this.direct < this.tdirect) {
            this.direct += this.tspeed;
        } else if (this.direct > this.tdirect) {
            this.direct -= this.tspeed;
        }
        while (this.direct - this.tdirect > 2048) {
            this.direct -= 4096;
        }
        while (this.direct - this.tdirect < -2048) {
            this.direct += 4096;
        }
    }

    public boolean isToTarget() {
        return this.tx == this.x && this.ty == this.y;
    }

    public void moveToTarget() {
        int n = this.speed;
        if (this.halfSpeed) {
            n >>= 1;
        }
        if (this.slowSpeed) {
            n >>= 2;
        }
        if (this.tx == this.x && this.ty == this.y) {
            return;
        }
        if (this.tx - this.x > -n && this.tx - this.x < n) {
            this.x = this.tx;
            if (this.ty - this.y > -n && this.ty - this.y < n) {
                this.y = this.ty;
            } else if (this.y > this.ty) {
                this.y -= n;
                if (this.isAutoDirect) {
                    this.setTargetDirect((byte)8);
                }
            } else if (this.y < this.ty) {
                this.y += n;
                if (this.isAutoDirect) {
                    this.setTargetDirect((byte)1);
                }
            }
        } else if (this.x > this.tx) {
            this.x -= n;
            if (this.isAutoDirect) {
                this.setTargetDirect((byte)2);
            }
        } else if (this.x < this.tx) {
            this.x += n;
            if (this.isAutoDirect) {
                this.setTargetDirect((byte)7);
            }
        }
    }

    public void setTarget(int n, int n2, int n3) {
        this.tx = n;
        this.ty = n2;
        this.tz = n3;
    }

    public void setTargetGrid(int n, int n2, int n3) {
        this.tx = (n << 7) + 64;
        this.ty = (n2 << 7) + 64;
        this.tz = (n3 << 7) + 64;
    }
}

